package unipotsdam.informatikkiste;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputType;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class MainActivity extends Activity implements View.OnClickListener {

    private LinkedList<AnswerEvent> events;
    private LinkedList<RiddleAnswer> answers;
    public RiddleIdView riddleIdView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        //Remove notification bar
        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_main);

        ((Button)findViewById(R.id.button)).setOnClickListener(this);
        ((Button)findViewById(R.id.buttonVideo)).setOnClickListener(this);
        this.riddleIdView = (RiddleIdView)findViewById(R.id.riddleIdView);

        this.events = new LinkedList<AnswerEvent>();
        this.answers = new LinkedList<RiddleAnswer>();

        //Der folgende Text würde das Video ersetzen.
        //(new DisplayAnswerEvent("Sehr geehrter Herr Kommissar, Sie haben also mein erstes Rätsel gelöst. Herzlichen Glückwunsch. Aber ich habe schon längst den nächsten Anschlag geplant und dieses Mal wird das gesamte Internet in Europa betroffen sein. Ich werde die größten Internetknoten hacken. Wenn ich einen Internetknoten Europas eingenommen habe, fallen in 3 Sekunden alle benachbarten Knoten auch unter meine Kontrolle. Dadurch kann ich in 12 Sekunden alle großen Knotenpunkte einnehmen. Kommen Sie her und versuchen Sie das zu verhindern! Und merken Sie sich eines für später: LOREMIPSUM", "30.06.",12)).fireEvent(this);

        riddleIdView.requestFocus();
        riddleIdView.activateTouchMeSequence();
        findViewById(R.id.editText).setOnFocusChangeListener(new DeleteOnClick());
        ((EditText)findViewById(R.id.editText)).setInputType(InputType.TYPE_TEXT_FLAG_NO_SUGGESTIONS|InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);

        try {
            parseRiddleData();
        } catch (Exception e) {
            e.printStackTrace();
            //Todo: Exception handling
        }
    }

    @Override
    protected void onResume(){
        super.onResume();
        if(!this.events.isEmpty()){
            this.events.pop().fireEvent(this);
        }
    }

    /**
     * is called, to load the data from the riddle_data.xml
     */
    private void parseRiddleData() throws Exception{
        XmlPullParserFactory parserFactory;
        parserFactory = XmlPullParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        XmlPullParser xpp = parserFactory.newPullParser();

        xpp.setInput(new InputStreamReader(getResources().openRawResource(R.raw.riddle_data)));
        int eventType = xpp.next();

        while(eventType != XmlPullParser.END_DOCUMENT){
            if(eventType == XmlPullParser.START_TAG) {
                if (xpp.getName().equalsIgnoreCase("riddle")) {
                    int riddleNumber = Integer.parseInt(xpp.getAttributeValue(null, "number"));

                    eventType = xpp.next();
                    while (!(eventType == XmlPullParser.END_TAG && xpp.getName().equalsIgnoreCase("riddle"))) {
                        if(eventType == XmlPullParser.START_TAG) {
                            if (xpp.getName().equalsIgnoreCase("answer")) {
                                String answerText = xpp.getAttributeValue(null, "text");
                                RiddleAnswer riddleAnswer = new RiddleAnswer(riddleNumber, answerText);
                                eventType = xpp.next();
                                while (!(eventType == XmlPullParser.END_TAG && xpp.getName().equalsIgnoreCase("answer"))) {
                                    if(eventType == XmlPullParser.START_TAG) {
                                        if (xpp.getName().equalsIgnoreCase("display")) {
                                            String message = xpp.getAttributeValue(null, "text");
                                            String date = xpp.getAttributeValue(null, "date");
                                            riddleAnswer.addAnswerEvent(new DisplayAnswerEvent(message, date, riddleNumber));
                                        }
                                    }
                                    eventType = xpp.next();
                                }
                                this.answers.add(riddleAnswer);
                            }
                        }
                        eventType = xpp.next();
                    }
                }
            }
            eventType = xpp.next();
        }
    }


    /**
     * is called to verify a potentious solution.
     */
    private void checkSolution(){
        int riddleId = this.riddleIdView.getRiddleId();

        boolean answeredCorrect = false;


        if(riddleId == 0){
            if(Pattern.matches(getResources().getString(R.string.reset_pattern),((EditText)findViewById(R.id.editText)).getText().toString())){
                VideoActivity.reset = true;
                super.onBackPressed();
            }
        }

        for(int i = 0; i < answers.size(); i++){
            LinkedList<AnswerEvent> tempList = this.answers.get(i).getEventsIfActivated(riddleId, ((EditText)findViewById(R.id.editText)).getText().toString());
            if(tempList != null){
                this.events.addAll(tempList);
                Log.d("Koffer","Right Answer");
                answeredCorrect = true;
            }
        }

        if(!answeredCorrect){
            wrongAnswer();
        }

        if(!this.events.isEmpty()){
            this.events.pop().fireEvent(this);
        }
    }

    @Override
    public void onBackPressed(){}

    /**
     * is called, if a wrong solution has been checked
     */
    private void wrongAnswer(){
        Log.d("Koffer","Wrong Answer");
        this.riddleIdView.setBackgroundColor(getResources().getColor(R.color.colorWrong));
        final Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                riddleIdView.resetBackgroundColor();
            }
        }, getResources().getInteger(R.integer.response_time));
    }

    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.button){
            this.checkSolution();
        }
        else if(v.getId() == R.id.buttonVideo){
            VideoActivity.reset = false;
            super.onBackPressed();
        }
    }

    private class DeleteOnClick implements View.OnFocusChangeListener{

        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            if(hasFocus){
                ((EditText)v).setText("");
            }
        }
    }
}
